/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.layout;

import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;

public class ScalableContentPane
extends Region {
    private Scale contentScaleTransform;
    private Property<Pane> contentPaneProperty = new SimpleObjectProperty();
    private double contentScaleWidth = 1.0;
    private double contentScaleHeight = 1.0;
    private boolean aspectScale = true;
    private boolean autoRescale = true;

    public ScalableContentPane() {
        this.setContentPane(new Pane());
        this.setPrefWidth(Double.NEGATIVE_INFINITY);
        this.setPrefHeight(Double.NEGATIVE_INFINITY);
    }

    public Pane getContentPane() {
        return (Pane)this.contentPaneProperty.getValue();
    }

    public final void setContentPane(Pane contentPane) {
        this.contentPaneProperty.setValue((Object)contentPane);
        contentPane.setManaged(false);
        this.initContentPaneListener();
        this.contentScaleTransform = new Scale(1.0, 1.0);
        this.getContentScaleTransform().setPivotX(0.0);
        this.getContentScaleTransform().setPivotY(0.0);
        this.getContentScaleTransform().setPivotZ(0.0);
        this.getContentPane().getTransforms().add((Object)this.getContentScaleTransform());
        this.getChildren().add((Object)contentPane);
    }

    public Property<Pane> contentPaneProperty() {
        return this.contentPaneProperty;
    }

    public final Scale getContentScaleTransform() {
        return this.contentScaleTransform;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double realWidth = Math.max(this.getWidth(), this.getContentPane().prefWidth(0.0));
        double realHeigh = Math.max(this.getHeight(), this.getContentPane().prefHeight(0.0));
        double leftAndRight = this.getInsets().getLeft() + this.getInsets().getRight();
        double topAndBottom = this.getInsets().getTop() + this.getInsets().getBottom();
        double contentWidth = this.getWidth() - leftAndRight;
        double contentHeight = this.getHeight() - topAndBottom;
        this.contentScaleWidth = contentWidth / realWidth;
        this.contentScaleHeight = contentHeight / realHeigh;
        if (this.isAspectScale()) {
            double scale;
            this.contentScaleWidth = scale = Math.min(this.contentScaleWidth, this.contentScaleHeight);
            this.contentScaleHeight = scale;
        }
        this.getContentScaleTransform().setX(this.contentScaleWidth);
        this.getContentScaleTransform().setY(this.contentScaleHeight);
        this.getContentPane().relocate(this.getInsets().getLeft(), this.getInsets().getTop());
        this.getContentPane().resize(contentWidth / this.contentScaleWidth, contentHeight / this.contentScaleHeight);
    }

    protected double computeMinWidth(double d) {
        double result = this.getInsets().getLeft() + this.getInsets().getRight() + 1.0;
        return result;
    }

    protected double computeMinHeight(double d) {
        double result = this.getInsets().getTop() + this.getInsets().getBottom() + 1.0;
        return result;
    }

    protected double computePrefWidth(double d) {
        double result = 1.0;
        return result;
    }

    protected double computePrefHeight(double d) {
        double result = 1.0;
        return result;
    }

    private void initContentPaneListener() {
        ChangeListener<Bounds> boundsListener = new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds t, Bounds t1) {
                if (ScalableContentPane.this.isAutoRescale()) {
                    ScalableContentPane.this.requestLayout();
                }
            }
        };
        ChangeListener<Number> numberListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                if (ScalableContentPane.this.isAutoRescale()) {
                    ScalableContentPane.this.requestLayout();
                }
            }
        };
        this.getContentPane().getChildren().addListener((ListChangeListener)new ListChangeListener<Node>((ChangeListener)boundsListener, (ChangeListener)numberListener){
            final /* synthetic */ ChangeListener val$boundsListener;
            final /* synthetic */ ChangeListener val$numberListener;
            {
                this.val$boundsListener = changeListener;
                this.val$numberListener = changeListener2;
            }

            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                while (c.next()) {
                    if (c.wasPermutated()) {
                        for (int i = c.getFrom(); i < c.getTo(); ++i) {
                        }
                        continue;
                    }
                    if (c.wasUpdated()) continue;
                    if (c.wasRemoved()) {
                        for (Node n : c.getRemoved()) {
                            n.boundsInLocalProperty().removeListener(this.val$boundsListener);
                            n.layoutXProperty().removeListener(this.val$numberListener);
                            n.layoutYProperty().removeListener(this.val$numberListener);
                        }
                        continue;
                    }
                    if (!c.wasAdded()) continue;
                    for (Node n : c.getAddedSubList()) {
                        n.boundsInLocalProperty().addListener(this.val$boundsListener);
                        n.layoutXProperty().addListener(this.val$numberListener);
                        n.layoutYProperty().addListener(this.val$numberListener);
                    }
                }
            }
        });
    }

    public boolean isAspectScale() {
        return this.aspectScale;
    }

    public void setAspectScale(boolean aspectScale) {
        this.aspectScale = aspectScale;
    }

    public boolean isAutoRescale() {
        return this.autoRescale;
    }

    public void setAutoRescale(boolean autoRescale) {
        this.autoRescale = autoRescale;
    }
}

