/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javafx.animation.Interpolator;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Shape;

public class EllipticalGradient {
    private List<Stop> sortedStops;

    public EllipticalGradient(Stop ... STOPS) {
        this(Arrays.asList(STOPS));
    }

    public EllipticalGradient(List<Stop> STOPS) {
        List<Object> stops;
        if (STOPS == null || STOPS.isEmpty()) {
            stops = new ArrayList();
            stops.add(new Stop(0.0, Color.TRANSPARENT));
            stops.add(new Stop(1.0, Color.TRANSPARENT));
        } else {
            stops = STOPS;
        }
        LinkedHashMap<Double, Object> stopMap = new LinkedHashMap<Double, Object>(stops.size());
        for (Stop stop : stops) {
            stopMap.put(stop.getOffset(), stop.getColor());
        }
        this.sortedStops = new LinkedList<Stop>();
        TreeSet sortedFractions = new TreeSet(((HashMap)stopMap).keySet());
        if ((Double)sortedFractions.last() < 1.0) {
            stopMap.put(1.0, ((HashMap)stopMap).get(sortedFractions.last()));
            sortedFractions.add(1.0);
        }
        if ((Double)sortedFractions.first() > 0.0) {
            stopMap.put(0.0, ((HashMap)stopMap).get(sortedFractions.first()));
            sortedFractions.add(0.0);
        }
        for (Double FRACTION : sortedFractions) {
            this.sortedStops.add(new Stop(FRACTION.doubleValue(), (Color)((HashMap)stopMap).get(FRACTION)));
        }
    }

    public List<Stop> getStops() {
        return this.sortedStops;
    }

    public Image getImage(double WIDTH, double HEIGHT) {
        return this.getImage(WIDTH, HEIGHT, new Point2D(WIDTH / 2.0, HEIGHT / 2.0));
    }

    public Image getImage(double WIDTH, double HEIGHT, Point2D CENTER) {
        int width = (int)WIDTH <= 0 ? 100 : (int)WIDTH;
        int height = (int)HEIGHT <= 0 ? 50 : (int)HEIGHT;
        double a = WIDTH / 2.0;
        double aSquare = a * a;
        double b = HEIGHT / 2.0;
        double bSquare = b * b;
        Color color = Color.TRANSPARENT;
        WritableImage RASTER = new WritableImage(width, height);
        PixelWriter PIXEL_WRITER = RASTER.getPixelWriter();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double isInside = ((double)x - CENTER.getX()) * ((double)x - CENTER.getX()) / aSquare + ((double)y - CENTER.getY()) * ((double)y - CENTER.getY()) / bSquare;
                isInside = isInside > 1.0 ? 1.0 : isInside;
                for (int i = 0; i < this.sortedStops.size() - 1; ++i) {
                    double currentOffset = this.sortedStops.get(i).getOffset();
                    double nextOffset = this.sortedStops.get(i + 1).getOffset();
                    if (Double.compare(isInside, currentOffset) <= 0 || Double.compare(isInside, nextOffset) > 0) continue;
                    double fraction = (isInside - currentOffset) / (nextOffset - currentOffset);
                    color = (Color)Interpolator.LINEAR.interpolate((Object)this.sortedStops.get(i).getColor(), (Object)this.sortedStops.get(i + 1).getColor(), fraction);
                }
                PIXEL_WRITER.setColor(x, y, color);
            }
        }
        return RASTER;
    }

    public ImagePattern getFill(Shape SHAPE) {
        return this.getFill(SHAPE, new Point2D(SHAPE.getLayoutBounds().getWidth() / 2.0, SHAPE.getLayoutBounds().getHeight() / 2.0));
    }

    public ImagePattern getFill(Shape SHAPE, Point2D CENTER) {
        double x = SHAPE.getLayoutBounds().getMinX();
        double y = SHAPE.getLayoutBounds().getMinY();
        double width = SHAPE.getLayoutBounds().getWidth();
        double height = SHAPE.getLayoutBounds().getHeight();
        return new ImagePattern(this.getImage(width, height, CENTER), x, y, width, height, false);
    }
}

