/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;

public class NodeUtil {
    private NodeUtil() {
        throw new AssertionError();
    }

    public static double screenX(Node node) {
        return node.localToScene(node.getBoundsInLocal()).getMinX() + node.getScene().getX() + node.getScene().getWindow().getX();
    }

    public static double screenY(Node node) {
        return node.localToScene(node.getBoundsInLocal()).getMinY() + node.getScene().getY() + node.getScene().getWindow().getY();
    }

    public static void removeFromParent(Node n) {
        if (n.getParent() instanceof Group) {
            ((Group)n.getParent()).getChildren().remove((Object)n);
        } else if (n.getParent() instanceof Pane) {
            ((Pane)n.getParent()).getChildren().remove((Object)n);
        } else {
            throw new IllegalArgumentException("Unsupported parent: " + n.getParent());
        }
    }

    public static void addToParent(Parent p, Node n) {
        if (p instanceof Group) {
            ((Group)p).getChildren().add((Object)n);
        } else if (p instanceof Pane) {
            ((Pane)p).getChildren().add((Object)n);
        } else {
            throw new IllegalArgumentException("Unsupported parent: " + p);
        }
    }

    public static Node getNode(Parent p, double sceneX, double sceneY, Class<?> nodeClass) {
        ArrayList rightOrder = new ArrayList();
        rightOrder.addAll(p.getChildrenUnmodifiable());
        Collections.reverse(rightOrder);
        for (Node n : rightOrder) {
            boolean contains = n.contains(n.sceneToLocal(sceneX, sceneY));
            if (!contains) continue;
            if (nodeClass.isAssignableFrom(n.getClass())) {
                return n;
            }
            if (!(n instanceof Parent)) continue;
            return NodeUtil.getNode((Parent)n, sceneX, sceneY, nodeClass);
        }
        return null;
    }

    public static List<Node> nodesWithParent(Parent p, List<Node> nodes) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node n : nodes) {
            if (!p.equals(n.getParent())) continue;
            result.add(n);
        }
        return result;
    }

    public static List<Node> nodesThatImplement(List<Node> nodes, Class<?> cls) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node n : nodes) {
            if (!cls.isAssignableFrom(n.getClass())) continue;
            result.add(n);
        }
        return result;
    }
}

