/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.util;

import java.util.Random;
import javafx.animation.Interpolator;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.SnapshotParametersBuilder;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Shape;
import jfxtras.labs.scene.control.gauge.GradientLookup;
import jfxtras.labs.util.BrushedMetalPaint;

public class Util {
    private static final SnapshotParameters SNAPSHOT_PARAMETER = SnapshotParametersBuilder.create().fill((Paint)Color.TRANSPARENT).build();

    public static String colorToCssColor(Color COLOR) {
        StringBuilder CSS_COLOR = new StringBuilder(19);
        CSS_COLOR.append("rgba(");
        CSS_COLOR.append((int)(COLOR.getRed() * 255.0)).append(", ");
        CSS_COLOR.append((int)(COLOR.getGreen() * 255.0)).append(", ");
        CSS_COLOR.append((int)(COLOR.getBlue() * 255.0)).append(", ");
        CSS_COLOR.append(COLOR.getOpacity()).append(");");
        return CSS_COLOR.toString();
    }

    public static String colorToWebColor(Color COLOR) {
        String blue;
        String green;
        String red = Integer.toHexString((int)(COLOR.getRed() * 255.0));
        if (red.length() == 1) {
            red = "0" + red;
        }
        if ((green = Integer.toHexString((int)(COLOR.getGreen() * 255.0))).length() == 1) {
            green = "0" + green;
        }
        if ((blue = Integer.toHexString((int)(COLOR.getBlue() * 255.0))).length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    public static Color webColorToColor(String COLOR) {
        int blue;
        int green;
        int red;
        double alpha = 1.0;
        if (COLOR.startsWith("0x")) {
            red = Integer.valueOf(COLOR.substring(2, 4), 16);
            green = Integer.valueOf(COLOR.substring(4, 6), 16);
            blue = Integer.valueOf(COLOR.substring(6, 8), 16);
            if (COLOR.length() > 8) {
                alpha = 0.00392156862745098 * (double)Integer.valueOf(COLOR.substring(8, 10), 16).intValue();
            }
        } else if (COLOR.startsWith("#")) {
            red = Integer.valueOf(COLOR.substring(1, 3), 16);
            green = Integer.valueOf(COLOR.substring(3, 5), 16);
            blue = Integer.valueOf(COLOR.substring(5, 7), 16);
            if (COLOR.length() > 7) {
                alpha = 0.00392156862745098 * (double)Integer.valueOf(COLOR.substring(7, 9), 16).intValue();
            }
        } else {
            red = Integer.valueOf(COLOR.substring(0, 2), 16);
            green = Integer.valueOf(COLOR.substring(2, 4), 16);
            blue = Integer.valueOf(COLOR.substring(4, 6), 16);
            if (COLOR.length() > 6) {
                alpha = 0.00392156862745098 * (double)Integer.valueOf(COLOR.substring(6, 8), 16).intValue();
            }
        }
        return Color.rgb((int)red, (int)green, (int)blue, (double)alpha);
    }

    public static double[] HSLtoRGB(double hue, double saturation, double luminance) {
        double normalizedHue = (hue % 360.0 + 360.0) % 360.0;
        hue = normalizedHue / 360.0;
        double q = luminance < 0.5 ? luminance * (1.0 + saturation) : luminance + saturation - saturation * luminance;
        double p = 2.0 * luminance - q;
        double red = Math.max(0.0, Util.HueToRGB(p, q, hue + 0.3333333432674408));
        double green = Math.max(0.0, Util.HueToRGB(p, q, hue));
        double blue = Math.max(0.0, Util.HueToRGB(p, q, hue - 0.3333333432674408));
        return new double[]{red, green, blue};
    }

    public static double[] RGBtoHSL(double red, double green, double blue) {
        double min = Math.min(red, Math.min(green, blue));
        double max = Math.max(red, Math.max(green, blue));
        double hue = 0.0;
        if (max == min) {
            hue = 0.0;
        } else if (max == red) {
            hue = ((green - blue) / (max - min) / 6.0 + 1.0) % 1.0;
        } else if (max == green) {
            hue = (blue - red) / (max - min) / 6.0 + 0.3333333333333333;
        } else if (max == blue) {
            hue = (red - green) / (max - min) / 6.0 + 0.6666666666666666;
        }
        double luminance = (max + min) / 2.0;
        double saturation = Double.compare(max, min) == 0 ? 0.0 : (luminance <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
        return new double[]{hue *= 360.0, saturation, luminance};
    }

    private static double HueToRGB(double P, double Q, double hue) {
        if (hue < 0.0) {
            hue += 1.0;
        }
        if (hue > 1.0) {
            hue -= 1.0;
        }
        if (6.0 * hue < 1.0) {
            return P + (Q - P) * 6.0 * hue;
        }
        if (2.0 * hue < 1.0) {
            return Q;
        }
        if (3.0 * hue < 2.0) {
            return P + (Q - P) * 6.0 * (0.6666666666666666 - hue);
        }
        return P;
    }

    public static Color biLinearInterpolateColor(Color COLOR_UL, Color COLOR_UR, Color COLOR_LL, Color COLOR_LR, float FRACTION_X, float FRACTION_Y) {
        Color INTERPOLATED_COLOR_X1 = (Color)Interpolator.LINEAR.interpolate((Object)COLOR_UL, (Object)COLOR_UR, (double)FRACTION_X);
        Color INTERPOLATED_COLOR_X2 = (Color)Interpolator.LINEAR.interpolate((Object)COLOR_LL, (Object)COLOR_LR, (double)FRACTION_X);
        return (Color)Interpolator.LINEAR.interpolate((Object)INTERPOLATED_COLOR_X1, (Object)INTERPOLATED_COLOR_X2, (double)FRACTION_Y);
    }

    public static Color darker(Color COLOR, double FRACTION) {
        double red = Util.clamp(0.0, 1.0, COLOR.getRed() * (1.0 - FRACTION));
        double green = Util.clamp(0.0, 1.0, COLOR.getGreen() * (1.0 - FRACTION));
        double blue = Util.clamp(0.0, 1.0, COLOR.getBlue() * (1.0 - FRACTION));
        return new Color(red, green, blue, COLOR.getOpacity());
    }

    public static Color brighter(Color COLOR, double FRACTION) {
        double red = Util.clamp(0.0, 1.0, COLOR.getRed() * (1.0 + FRACTION));
        double green = Util.clamp(0.0, 1.0, COLOR.getGreen() * (1.0 + FRACTION));
        double blue = Util.clamp(0.0, 1.0, COLOR.getBlue() * (1.0 + FRACTION));
        return new Color(red, green, blue, COLOR.getOpacity());
    }

    public static double colorDistance(Color COLOR1, Color COLOR2) {
        double DELTA_R = COLOR2.getRed() - COLOR1.getRed();
        double DELTA_G = COLOR2.getGreen() - COLOR1.getGreen();
        double DELTA_B = COLOR2.getBlue() - COLOR1.getBlue();
        return Math.sqrt(DELTA_R * DELTA_R + DELTA_G * DELTA_G + DELTA_B * DELTA_B);
    }

    public static boolean isDark(Color COLOR) {
        double DISTANCE_TO_WHITE = Util.colorDistance(COLOR, Color.WHITE);
        double DISTANCE_TO_BLACK = Util.colorDistance(COLOR, Color.BLACK);
        return DISTANCE_TO_BLACK < DISTANCE_TO_WHITE;
    }

    public static boolean isBright(Color COLOR) {
        return !Util.isDark(COLOR);
    }

    public static Image takeSnapshot(Node NODE) {
        WritableImage img = new WritableImage((int)NODE.getLayoutBounds().getWidth(), (int)NODE.getLayoutBounds().getHeight());
        return NODE.snapshot(SNAPSHOT_PARAMETER, img);
    }

    public static Canvas createConicalGradient(Shape SHAPE, Stop[] STOPS, double ROTATION_OFFSET) {
        Canvas CANVAS = new Canvas(SHAPE.getLayoutBounds().getWidth(), SHAPE.getLayoutBounds().getHeight());
        Util.createConicalGradient(CANVAS, SHAPE, STOPS, ROTATION_OFFSET);
        return CANVAS;
    }

    public static void createConicalGradient(Canvas CANVAS, Shape SHAPE, Stop[] STOPS, double ROTATION_OFFSET) {
        if (CANVAS.getLayoutBounds().getWidth() < SHAPE.getLayoutBounds().getWidth()) {
            CANVAS.setWidth(SHAPE.getLayoutBounds().getWidth());
        }
        if (CANVAS.getLayoutBounds().getHeight() < SHAPE.getLayoutBounds().getHeight()) {
            CANVAS.setHeight(SHAPE.getLayoutBounds().getHeight());
        }
        Shape CLIP = SHAPE;
        CLIP.setTranslateX(-SHAPE.getLayoutBounds().getMinX());
        CLIP.setTranslateY(-SHAPE.getLayoutBounds().getMinY());
        CANVAS.setLayoutX(SHAPE.getLayoutBounds().getMinX());
        CANVAS.setLayoutY(SHAPE.getLayoutBounds().getMinY());
        CANVAS.setClip((Node)CLIP);
        GraphicsContext CTX = CANVAS.getGraphicsContext2D();
        Bounds BOUNDS = SHAPE.getLayoutBounds();
        Point2D CENTER = new Point2D(BOUNDS.getWidth() / 2.0, BOUNDS.getHeight() / 2.0);
        double RADIUS = Math.sqrt(BOUNDS.getWidth() * BOUNDS.getWidth() + BOUNDS.getHeight() * BOUNDS.getHeight()) / 2.0;
        double ANGLE_STEP = 0.1;
        GradientLookup COLOR_LOOKUP = new GradientLookup(STOPS);
        CTX.translate(CENTER.getX(), CENTER.getY());
        CTX.rotate(-90.0 + ROTATION_OFFSET);
        CTX.translate(-CENTER.getX(), -CENTER.getY());
        int size = STOPS.length - 1;
        for (int i = 0; i < size; ++i) {
            double angle = STOPS[i].getOffset() * 360.0;
            while (Double.compare(angle, STOPS[i + 1].getOffset() * 360.0) <= 0) {
                CTX.beginPath();
                CTX.moveTo(CENTER.getX() - RADIUS, CENTER.getY() - RADIUS);
                CTX.setFill((Paint)COLOR_LOOKUP.getColorAt(angle / 360.0));
                if (RADIUS > 0.0) {
                    CTX.fillArc(CENTER.getX() - RADIUS, CENTER.getY() - RADIUS, 2.0 * RADIUS, 2.0 * RADIUS, angle, 0.1, ArcType.ROUND);
                } else {
                    CTX.moveTo(CENTER.getX() - RADIUS, CENTER.getY() - RADIUS);
                }
                CTX.fill();
                angle += 0.1;
            }
        }
    }

    public static ImagePattern createCarbonPattern() {
        double WIDTH = 12.0;
        double HEIGHT = 12.0;
        Canvas CANVAS = new Canvas(12.0, 12.0);
        GraphicsContext CTX = CANVAS.getGraphicsContext2D();
        double offsetY = 0.0;
        CTX.beginPath();
        CTX.rect(0.0, 0.0, 6.0, 6.0);
        CTX.closePath();
        CTX.setFill((Paint)new LinearGradient(0.0, offsetY * 12.0, 0.0, 6.0 + offsetY * 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)35, (int)35, (int)35)), new Stop(1.0, Color.rgb((int)23, (int)23, (int)23))}));
        CTX.fill();
        CTX.beginPath();
        CTX.rect(0.9999960000000001, 0.0, 3.999996, 4.999992);
        CTX.closePath();
        offsetY = 0.0;
        CTX.setFill((Paint)new LinearGradient(0.0, offsetY * 12.0, 0.0, 4.999992 + offsetY * 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)38, (int)38, (int)38)), new Stop(1.0, Color.rgb((int)30, (int)30, (int)30))}));
        CTX.fill();
        CTX.beginPath();
        CTX.rect(6.0, 6.0, 6.0, 6.0);
        CTX.closePath();
        offsetY = 0.5;
        CTX.setFill((Paint)new LinearGradient(0.0, offsetY * 12.0, 0.0, 6.0 + offsetY * 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)35, (int)35, (int)35)), new Stop(1.0, Color.rgb((int)23, (int)23, (int)23))}));
        CTX.fill();
        CTX.beginPath();
        CTX.rect(6.999995999999999, 6.0, 3.999996, 4.999992);
        CTX.closePath();
        offsetY = 0.5;
        CTX.setFill((Paint)new LinearGradient(0.0, offsetY * 12.0, 0.0, 4.999992 + offsetY * 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)38, (int)38, (int)38)), new Stop(1.0, Color.rgb((int)30, (int)30, (int)30))}));
        CTX.fill();
        CTX.beginPath();
        CTX.rect(6.0, 0.0, 6.0, 6.0);
        CTX.closePath();
        offsetY = 0.0;
        CTX.setFill((Paint)new LinearGradient(0.0, offsetY * 12.0, 0.0, 6.0 + offsetY * 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)48, (int)48, (int)48)), new Stop(1.0, Color.rgb((int)40, (int)40, (int)40))}));
        CTX.fill();
        CTX.beginPath();
        CTX.rect(6.999995999999999, 0.9999960000000001, 3.999996, 4.999992);
        CTX.closePath();
        offsetY = 0.083333;
        CTX.setFill((Paint)new LinearGradient(0.0, offsetY * 12.0, 0.0, 4.999992 + offsetY * 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)53, (int)53, (int)53)), new Stop(1.0, Color.rgb((int)45, (int)45, (int)45))}));
        CTX.fill();
        CTX.beginPath();
        CTX.rect(0.0, 6.0, 6.0, 6.0);
        CTX.closePath();
        offsetY = 0.5;
        CTX.setFill((Paint)new LinearGradient(0.0, offsetY * 12.0, 0.0, 6.0 + offsetY * 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)48, (int)48, (int)48)), new Stop(1.0, Color.rgb((int)40, (int)40, (int)40))}));
        CTX.fill();
        CTX.beginPath();
        CTX.rect(0.9999960000000001, 6.999995999999999, 3.999996, 4.999992);
        CTX.closePath();
        offsetY = 0.583333;
        CTX.setFill((Paint)new LinearGradient(0.0, offsetY * 12.0, 0.0, 4.999992 + offsetY * 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)53, (int)53, (int)53)), new Stop(1.0, Color.rgb((int)45, (int)45, (int)45))}));
        CTX.fill();
        WritableImage PATTERN_IMAGE = CANVAS.snapshot(SNAPSHOT_PARAMETER, null);
        ImagePattern PATTERN = new ImagePattern((Image)PATTERN_IMAGE, 0.0, 0.0, 12.0, 12.0, false);
        return PATTERN;
    }

    public static ImagePattern createPunchedSheetPattern(Color TEXTURE_COLOR) {
        double WIDTH = 15.0;
        double HEIGHT = 15.0;
        Canvas CANVAS = new Canvas(15.0, 15.0);
        GraphicsContext CTX = CANVAS.getGraphicsContext2D();
        CTX.beginPath();
        CTX.rect(0.0, 0.0, 15.0, 15.0);
        CTX.closePath();
        CTX.setFill((Paint)TEXTURE_COLOR);
        CTX.fill();
        CTX.beginPath();
        CTX.moveTo(0.0, 3.9999900000000004);
        CTX.bezierCurveTo(0.0, 6.0, 0.99999, 6.99999, 3.0, 6.99999);
        CTX.bezierCurveTo(4.999995, 6.99999, 6.0, 6.0, 6.0, 3.9999900000000004);
        CTX.bezierCurveTo(6.0, 1.9999950000000002, 4.999995, 0.99999, 3.0, 0.99999);
        CTX.bezierCurveTo(0.99999, 0.99999, 0.0, 1.9999950000000002, 0.0, 3.9999900000000004);
        CTX.closePath();
        CTX.setFill((Paint)new LinearGradient(0.0, 0.99999, 0.0, 6.99999, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)0, (int)0)), new Stop(1.0, Color.rgb((int)68, (int)68, (int)68))}));
        CTX.fill();
        CTX.beginPath();
        CTX.moveTo(0.0, 3.0);
        CTX.bezierCurveTo(0.0, 4.999995, 0.99999, 6.0, 3.0, 6.0);
        CTX.bezierCurveTo(4.999995, 6.0, 6.0, 4.999995, 6.0, 3.0);
        CTX.bezierCurveTo(6.0, 0.99999, 4.999995, 0.0, 3.0, 0.0);
        CTX.bezierCurveTo(0.99999, 0.0, 0.0, 0.99999, 0.0, 3.0);
        CTX.closePath();
        CTX.setFill((Paint)TEXTURE_COLOR.darker().darker());
        CTX.fill();
        CTX.beginPath();
        CTX.moveTo(6.99999, 10.999995);
        CTX.bezierCurveTo(6.99999, 12.99999, 7.999994999999999, 13.999995, 9.99999, 13.999995);
        CTX.bezierCurveTo(12.0, 13.999995, 12.99999, 12.99999, 12.99999, 10.999995);
        CTX.bezierCurveTo(12.99999, 9.0, 12.0, 7.999994999999999, 9.99999, 7.999994999999999);
        CTX.bezierCurveTo(7.999994999999999, 7.999994999999999, 6.99999, 9.0, 6.99999, 10.999995);
        CTX.closePath();
        CTX.setFill((Paint)new LinearGradient(0.0, 7.999994999999999, 0.0, 13.999995, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)0, (int)0)), new Stop(1.0, Color.rgb((int)68, (int)68, (int)68))}));
        CTX.fill();
        CTX.beginPath();
        CTX.moveTo(6.99999, 9.99999);
        CTX.bezierCurveTo(6.99999, 12.0, 7.999994999999999, 12.99999, 9.99999, 12.99999);
        CTX.bezierCurveTo(12.0, 12.99999, 12.99999, 12.0, 12.99999, 9.99999);
        CTX.bezierCurveTo(12.99999, 7.999994999999999, 12.0, 6.99999, 9.99999, 6.99999);
        CTX.bezierCurveTo(7.999994999999999, 6.99999, 6.99999, 7.999994999999999, 6.99999, 9.99999);
        CTX.closePath();
        CTX.setFill((Paint)TEXTURE_COLOR.darker().darker());
        CTX.fill();
        WritableImage PATTERN_IMAGE = CANVAS.snapshot(SNAPSHOT_PARAMETER, null);
        ImagePattern PATTERN = new ImagePattern((Image)PATTERN_IMAGE, 0.0, 0.0, 15.0, 15.0, false);
        return PATTERN;
    }

    public static Image createNoiseImage(double WIDTH, double HEIGHT, Color COLOR) {
        return Util.createNoiseImage(WIDTH, HEIGHT, COLOR.darker(), COLOR.brighter(), 30.0);
    }

    public static Image createNoiseImage(double WIDTH, double HEIGHT, Color DARK_COLOR, Color BRIGHT_COLOR, double ALPHA_VARIATION_IN_PERCENT) {
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return null;
        }
        double alphaVariationInPercent = Util.clamp(0.0, 100.0, ALPHA_VARIATION_IN_PERCENT);
        WritableImage IMAGE = new WritableImage((int)WIDTH, (int)HEIGHT);
        PixelWriter PIXEL_WRITER = IMAGE.getPixelWriter();
        Random BW_RND = new Random();
        Random ALPHA_RND = new Random();
        double ALPHA_START = alphaVariationInPercent / 100.0 / 2.0;
        double ALPHA_VARIATION = alphaVariationInPercent / 100.0;
        int y = 0;
        while ((double)y < HEIGHT) {
            int x = 0;
            while ((double)x < WIDTH) {
                Color noiseColor = BW_RND.nextBoolean() ? BRIGHT_COLOR : DARK_COLOR;
                double noiseAlpha = Util.clamp(0.0, 1.0, ALPHA_START + ALPHA_RND.nextDouble() * ALPHA_VARIATION);
                PIXEL_WRITER.setColor(x, y, Color.color((double)noiseColor.getRed(), (double)noiseColor.getGreen(), (double)noiseColor.getBlue(), (double)noiseAlpha));
                ++x;
            }
            ++y;
        }
        return IMAGE;
    }

    public static Paint applyNoisyBackground(Shape SHAPE, Color TEXTURE_COLOR) {
        int WIDTH = (int)SHAPE.getLayoutBounds().getWidth();
        int HEIGHT = (int)SHAPE.getLayoutBounds().getHeight();
        WritableImage IMAGE = new WritableImage(WIDTH, HEIGHT);
        PixelWriter PIXEL_WRITER = IMAGE.getPixelWriter();
        Random BW_RND = new Random();
        Random ALPHA_RND = new Random();
        double ALPHA_START = 0.045;
        double ALPHA_VARIATION = 0.09;
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                Color noiseColor = BW_RND.nextBoolean() ? TEXTURE_COLOR.brighter() : TEXTURE_COLOR.darker();
                double noiseAlpha = Util.clamp(0.0, 1.0, 0.045 + ALPHA_RND.nextDouble() * 0.09);
                PIXEL_WRITER.setColor(x, y, Color.color((double)noiseColor.getRed(), (double)noiseColor.getGreen(), (double)noiseColor.getBlue(), (double)noiseAlpha));
            }
        }
        double x = SHAPE.getLayoutBounds().getMinX();
        double y = SHAPE.getLayoutBounds().getMinY();
        double width = SHAPE.getLayoutBounds().getWidth();
        double height = SHAPE.getLayoutBounds().getHeight();
        return new ImagePattern((Image)IMAGE, x, y, width, height, false);
    }

    public static Image createBrushedMetalImage(double WIDTH, double HEIGHT, Color TEXTURE_COLOR) {
        BrushedMetalPaint PAINT = new BrushedMetalPaint(TEXTURE_COLOR);
        return PAINT.getImage(WIDTH, HEIGHT);
    }

    public static Paint applyBrushedMetalBackground(Shape SHAPE, Color TEXTURE_COLOR) {
        BrushedMetalPaint PAINT = new BrushedMetalPaint(TEXTURE_COLOR);
        return PAINT.apply(SHAPE);
    }

    public static DoubleBinding getMaxSquareSizeBinding(final DoubleProperty WIDTH_PROPERTY, final DoubleProperty HEIGHT_PROPERTY) {
        DoubleBinding MAX_SQUARE_SIZE = new DoubleBinding(){
            {
                super.bind(new Observable[]{WIDTH_PROPERTY, HEIGHT_PROPERTY});
            }

            protected double computeValue() {
                double VALUE = WIDTH_PROPERTY.get() < HEIGHT_PROPERTY.get() ? WIDTH_PROPERTY.get() : HEIGHT_PROPERTY.get();
                return VALUE;
            }
        };
        return MAX_SQUARE_SIZE;
    }

    public static DoubleBinding getMaxSquareSizeBinding(final ReadOnlyDoubleProperty WIDTH_PROPERTY, final ReadOnlyDoubleProperty HEIGHT_PROPERTY) {
        DoubleBinding MAX_SQUARE_SIZE = new DoubleBinding(){
            {
                super.bind(new Observable[]{WIDTH_PROPERTY, HEIGHT_PROPERTY});
            }

            protected double computeValue() {
                double VALUE = WIDTH_PROPERTY.get() < HEIGHT_PROPERTY.get() ? WIDTH_PROPERTY.get() : HEIGHT_PROPERTY.get();
                return VALUE;
            }
        };
        return MAX_SQUARE_SIZE;
    }

    public static double clamp(double MIN, double MAX, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }
}

