/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.util.event;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;
import jfxtras.labs.util.event.DraggingControllerImpl;
import jfxtras.labs.util.event.EventHandlerGroup;
import jfxtras.labs.util.event.RectangleSelectionControllerImpl;

public class MouseControlUtil {
    private MouseControlUtil() {
        throw new AssertionError();
    }

    public static void makeDraggable(Node n) {
        MouseControlUtil.makeDraggable(n, null, null);
    }

    public static void addSelectionRectangleGesture(Parent root, Rectangle rect) {
        MouseControlUtil.addSelectionRectangleGesture(root, rect, null, null, null);
    }

    public static void addSelectionRectangleGesture(Parent root, Rectangle rect, EventHandler<MouseEvent> dragHandler, EventHandler<MouseEvent> pressHandler, EventHandler<MouseEvent> releaseHandler) {
        EventHandlerGroup<MouseEvent> dragHandlerGroup = new EventHandlerGroup<MouseEvent>();
        EventHandlerGroup<MouseEvent> pressHandlerGroup = new EventHandlerGroup<MouseEvent>();
        EventHandlerGroup<MouseEvent> releaseHandlerGroup = new EventHandlerGroup<MouseEvent>();
        if (dragHandler != null) {
            dragHandlerGroup.addHandler(dragHandler);
        }
        if (pressHandler != null) {
            pressHandlerGroup.addHandler(pressHandler);
        }
        if (releaseHandler != null) {
            releaseHandlerGroup.addHandler(releaseHandler);
        }
        root.setOnMouseDragged(dragHandlerGroup);
        root.setOnMousePressed(pressHandlerGroup);
        root.setOnMouseReleased(releaseHandlerGroup);
        RectangleSelectionControllerImpl selectionHandler = new RectangleSelectionControllerImpl();
        selectionHandler.apply(root, rect, dragHandlerGroup, pressHandlerGroup, releaseHandlerGroup);
    }

    public static void makeDraggable(Node n, EventHandler<MouseEvent> dragHandler, EventHandler<MouseEvent> pressHandler) {
        EventHandlerGroup<MouseEvent> dragHandlerGroup = new EventHandlerGroup<MouseEvent>();
        EventHandlerGroup<MouseEvent> pressHandlerGroup = new EventHandlerGroup<MouseEvent>();
        if (dragHandler != null) {
            dragHandlerGroup.addHandler(dragHandler);
        }
        if (pressHandler != null) {
            pressHandlerGroup.addHandler(pressHandler);
        }
        n.setOnMouseDragged(dragHandlerGroup);
        n.setOnMousePressed(pressHandlerGroup);
        n.layoutXProperty().unbind();
        n.layoutYProperty().unbind();
        MouseControlUtil._makeDraggable(n, dragHandlerGroup, pressHandlerGroup);
    }

    private static void _makeDraggable(Node n, EventHandlerGroup<MouseEvent> dragHandler, EventHandlerGroup<MouseEvent> pressHandler) {
        DraggingControllerImpl draggingController = new DraggingControllerImpl();
        draggingController.apply(n, dragHandler, pressHandler);
    }
}

