/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.util.grid;

import com.sun.javafx.collections.ObservableListWrapper;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Pagination;
import javafx.util.Callback;
import jfxtras.labs.scene.control.grid.GridCell;
import jfxtras.labs.scene.control.grid.GridView;

public class GridPaginationHelper<T> {
    private Pagination pagination;
    private ObservableList<T> items;
    private Callback<GridView<T>, GridCell<T>> gridCellFactory;
    private Callback<Integer, Node> pageFactory;
    private DoubleProperty cellWidth;
    private DoubleProperty cellHeight;
    private DoubleProperty horizontalCellSpacing;
    private DoubleProperty verticalCellSpacing;
    private ChangeListener<Number> defaultUpdateListener;

    public GridPaginationHelper(Pagination pagination, final ObservableList<T> items, Callback<GridView<T>, GridCell<T>> gridCellFactory) {
        this.pagination = pagination;
        this.items = items;
        this.gridCellFactory = gridCellFactory;
        this.defaultUpdateListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                GridPaginationHelper.this.update();
            }
        };
        this.pageFactory = new Callback<Integer, Node>(){

            public Node call(Integer arg0) {
                GridView gridView = null;
                gridView = new GridView();
                int startIndex = GridPaginationHelper.this.getCellStartIndexForPage(arg0);
                ObservableListWrapper currentItems = new ObservableListWrapper(items.subList(startIndex, Math.min(startIndex + GridPaginationHelper.this.calcMaxVisibleCellsPerPage(), items.size())));
                gridView.setItems(currentItems);
                gridView.setCellFactory(GridPaginationHelper.this.gridCellFactory);
                gridView.cellHeightProperty().bind((ObservableValue)GridPaginationHelper.this.cellHeightProperty());
                gridView.cellWidthProperty().bind((ObservableValue)GridPaginationHelper.this.cellWidthProperty());
                gridView.horizontalCellSpacingProperty().bind((ObservableValue)GridPaginationHelper.this.horizontalCellSpacingProperty());
                gridView.verticalCellSpacingProperty().bind((ObservableValue)GridPaginationHelper.this.verticalCellSpacingProperty());
                gridView.cellHeightProperty().addListener(GridPaginationHelper.this.defaultUpdateListener);
                gridView.cellWidthProperty().addListener(GridPaginationHelper.this.defaultUpdateListener);
                gridView.horizontalCellSpacingProperty().addListener(GridPaginationHelper.this.defaultUpdateListener);
                gridView.verticalCellSpacingProperty().addListener(GridPaginationHelper.this.defaultUpdateListener);
                return gridView;
            }
        };
        GridView dummyGridView = new GridView();
        this.cellHeightProperty().setValue((Number)dummyGridView.getCellHeight());
        this.cellWidthProperty().setValue((Number)dummyGridView.getCellWidth());
        this.verticalCellSpacingProperty().setValue((Number)dummyGridView.getVerticalCellSpacing());
        this.horizontalCellSpacingProperty().setValue((Number)dummyGridView.getHorizontalCellSpacing());
        items.addListener(new ListChangeListener<T>(){

            public void onChanged(ListChangeListener.Change<? extends T> arg0) {
                GridPaginationHelper.this.update();
            }
        });
        pagination.widthProperty().addListener(this.defaultUpdateListener);
        pagination.heightProperty().addListener(this.defaultUpdateListener);
        pagination.setPageFactory(this.pageFactory);
    }

    private void update() {
        int firstCellOnPage = this.calcMaxVisibleCellsPerPage() * this.pagination.getCurrentPageIndex();
        this.pagination.setPageCount(this.calcPageCount());
        this.pagination.setCurrentPageIndex((int)Math.floor(firstCellOnPage / this.calcMaxVisibleCellsPerPage()));
    }

    private int calcMaxVisibleCellsPerPage() {
        return Math.max(1, this.computeMaxCellsInOneRow() * this.computeMaxRowsPerPage());
    }

    private int computeMaxRowsPerPage() {
        double cellHeight = this.getCellHeight() + this.getVerticalCellSpacing() + this.getVerticalCellSpacing();
        return (int)Math.floor((this.pagination.getHeight() - 64.0) / cellHeight);
    }

    private int computeMaxCellsInOneRow() {
        double cellWidth = this.getHorizontalCellSpacing() + this.getCellWidth() + this.getHorizontalCellSpacing();
        return (int)Math.floor(this.pagination.getWidth() / cellWidth);
    }

    private int getCellStartIndexForPage(int pageIndex) {
        return this.calcMaxVisibleCellsPerPage() * pageIndex;
    }

    private int calcPageCount() {
        return (int)Math.floor(this.items.size() / this.calcMaxVisibleCellsPerPage());
    }

    public void setHorizontalCellSpacing(double value) {
        this.horizontalCellSpacingProperty().set(value);
    }

    public double getHorizontalCellSpacing() {
        return this.horizontalCellSpacing == null ? null : Double.valueOf(this.horizontalCellSpacing.get());
    }

    public final DoubleProperty horizontalCellSpacingProperty() {
        if (this.horizontalCellSpacing == null) {
            this.horizontalCellSpacing = new SimpleDoubleProperty((Object)this, "horizontalCellSpacing");
        }
        return this.horizontalCellSpacing;
    }

    public void setVerticalCellSpacing(double value) {
        this.verticalCellSpacingProperty().set(value);
    }

    public double getVerticalCellSpacing() {
        return this.verticalCellSpacing == null ? null : Double.valueOf(this.verticalCellSpacing.get());
    }

    public final DoubleProperty verticalCellSpacingProperty() {
        if (this.verticalCellSpacing == null) {
            this.verticalCellSpacing = new SimpleDoubleProperty((Object)this, "verticalCellSpacing");
        }
        return this.verticalCellSpacing;
    }

    public final DoubleProperty cellWidthProperty() {
        if (this.cellWidth == null) {
            this.cellWidth = new SimpleDoubleProperty((Object)this, "cellWidth");
        }
        return this.cellWidth;
    }

    public void setCellWidth(double value) {
        this.cellWidthProperty().set(value);
    }

    public double getCellWidth() {
        return this.cellWidth == null ? null : Double.valueOf(this.cellWidth.get());
    }

    public final DoubleProperty cellHeightProperty() {
        if (this.cellHeight == null) {
            this.cellHeight = new SimpleDoubleProperty((Object)this, "cellHeight");
        }
        return this.cellHeight;
    }

    public void setCellHeight(double value) {
        this.cellHeightProperty().set(value);
    }

    public double getCellHeight() {
        return this.cellHeight == null ? null : Double.valueOf(this.cellHeight.get());
    }
}

