/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.FXMLBuilder;
import anywheresoftware.b4j.objects.LayoutBuilder;
import anywheresoftware.b4j.objects.LayoutValues;
import anywheresoftware.b4j.objects.NodeWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Control;
import javafx.scene.control.MenuBar;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

@BA.Hide
public class PaneWrapper<T extends Pane>
extends NodeWrapper<T>
implements BA.IterableList {
    public static Object ORIENTATION_RIGHT_TO_LEFT = NodeOrientation.RIGHT_TO_LEFT;
    public static Object ORIENTATION_LEFT_TO_RIGHT = NodeOrientation.LEFT_TO_RIGHT;
    public static Object ORIENTATION_INHERIT = NodeOrientation.INHERIT;
    @BA.Hide
    public static final LinkedList<NativeAndWrapper> nativeToWrapper = new LinkedList();

    @BA.RaisesSynchronousEvents
    public LayoutValues LoadLayout(BA tba, String LayoutFile) throws Exception {
        String filelower = LayoutFile.toLowerCase(BA.cul);
        boolean fxml = true;
        if (!filelower.contains(".")) {
            if (this.getClass().getResourceAsStream("/Files/" + LayoutFile + ".fxml") != null) {
                LayoutFile = String.valueOf(LayoutFile) + ".fxml";
            } else {
                LayoutFile = String.valueOf(LayoutFile) + ".bjl";
                fxml = false;
            }
        } else if (filelower.endsWith(".bjl")) {
            fxml = false;
        }
        if (fxml) {
            FXMLBuilder.LoadLayout((Pane)this.getObject(), tba, LayoutFile);
            return new LayoutValues();
        }
        LayoutBuilder lb = new LayoutBuilder(null);
        return lb.loadLayout(LayoutFile, tba, (Pane)this.getObject());
    }

    @Override
    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        super.innerInitialize(ba, eventName, keepOldObject);
        final Pane obj = (Pane)this.getObject();
        final boolean raiseEvent = ba.subExists(String.valueOf(eventName) + "_resize");
        new ResizeEventManager(obj, null, new Runnable(){

            @Override
            public void run() {
                LayoutBuilder.LayoutData ld = (LayoutBuilder.LayoutData)AbsObjectWrapper.getExtraTags(obj).get("layoutdata");
                if (ld != null) {
                    new LayoutBuilder(ld).resizeLayout(ba, obj);
                }
                if (raiseEvent) {
                    ba.raiseEvent(obj, String.valueOf(eventName) + "_resize", obj.getWidth(), obj.getHeight());
                }
            }
        });
        if (ba.subExists(String.valueOf(eventName) + "_touch")) {
            ((Pane)this.getObject()).setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    ba.raiseEvent(obj, String.valueOf(eventName) + "_touch", 0, Float.valueOf((float)arg0.getX()), Float.valueOf((float)arg0.getY()));
                }
            });
            ((Pane)this.getObject()).setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    ba.raiseEvent(obj, String.valueOf(eventName) + "_touch", 1, Float.valueOf((float)arg0.getX()), Float.valueOf((float)arg0.getY()));
                }
            });
            ((Pane)this.getObject()).setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    ba.raiseEvent(obj, String.valueOf(eventName) + "_touch", 2, Float.valueOf((float)arg0.getX()), Float.valueOf((float)arg0.getY()));
                }
            });
            ((Pane)this.getObject()).setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    ba.raiseEvent(obj, String.valueOf(eventName) + "_touch", 100, Float.valueOf((float)arg0.getX()), Float.valueOf((float)arg0.getY()));
                }
            });
        }
    }

    public BA.IterableList GetAllViewsRecursive() {
        return new AllViewsIterator((Parent)this.getObject());
    }

    @BA.Hide
    public void SetLayoutAnimatedImpl(int Duration2, double Left, double Top, double PrefWidth, double PrefHeight, boolean raiseAnimationCompleted) {
        if (Duration2 == 0) {
            this.setTop(Top);
            this.setLeft(Left);
            this.setPrefWidth(PrefWidth);
            this.setPrefHeight(PrefHeight);
            if (raiseAnimationCompleted) {
                this.raiseAnimationCompletedEvent(null, "SetLayoutAnimated");
            }
            return;
        }
        KeyValue left = new KeyValue((WritableValue)((Pane)this.getObject()).layoutXProperty(), (Object)(Left - ((Pane)this.getObject()).getLayoutBounds().getMinX()));
        KeyValue top = new KeyValue((WritableValue)((Pane)this.getObject()).layoutYProperty(), (Object)(Top - ((Pane)this.getObject()).getLayoutBounds().getMinY()));
        KeyValue width = new KeyValue((WritableValue)((Pane)this.getObject()).prefWidthProperty(), (Object)PrefWidth);
        KeyValue height = new KeyValue((WritableValue)((Pane)this.getObject()).prefHeightProperty(), (Object)PrefHeight);
        KeyFrame frame = new KeyFrame(Duration.millis((double)Duration2), new KeyValue[]{left, top, width, height});
        Timeline timeline = new Timeline(new KeyFrame[]{frame});
        if (raiseAnimationCompleted) {
            this.raiseAnimationCompletedEvent((Animation)timeline, "SetLayoutAnimated");
        }
        timeline.play();
    }

    public void SetLayoutAnimated(int Duration2, double Left, double Top, double PrefWidth, double PrefHeight) {
        this.SetLayoutAnimatedImpl(Duration2, Left, Top, PrefWidth, PrefHeight, true);
    }

    @Override
    public double getPrefHeight() {
        return ((Pane)this.getObject()).getPrefHeight();
    }

    @Override
    public void setPrefHeight(double d) {
        ((Pane)this.getObject()).setPrefHeight(d);
    }

    @Override
    public double getPrefWidth() {
        return ((Pane)this.getObject()).getPrefWidth();
    }

    @Override
    public void setPrefWidth(double d) {
        ((Pane)this.getObject()).setPrefWidth(d);
    }

    public double getHeight() {
        return ((Pane)this.getObject()).getHeight();
    }

    public double getWidth() {
        return ((Pane)this.getObject()).getWidth();
    }

    public void AddNode(Node Node2, double Left, double Top, double Width, double Height) {
        this.InsertNode(this.getNumberOfNodes(), Node2, Left, Top, Width, Height);
    }

    public void RemoveAllNodes() {
        ((Pane)this.getObject()).getChildren().clear();
    }

    public void RemoveNodeAt(int Index) {
        ((Pane)this.getObject()).getChildren().remove(Index);
    }

    public void InsertNode(int Index, Node Node2, double Left, double Top, double Width, double Height) {
        ((Pane)this.getObject()).getChildren().add(Index, (Object)Node2);
        if (Left != -1.0) {
            Node2.setLayoutX(Left - Node2.getLayoutBounds().getMinX());
        }
        if (Top != -1.0) {
            Node2.setLayoutY(Top - Node2.getLayoutBounds().getMinY());
        }
        if (Node2 instanceof MenuBar) {
            MenuBar mb = (MenuBar)Node2;
            AnchorPane.setLeftAnchor((Node)mb, (Double)0.0);
            AnchorPane.setRightAnchor((Node)mb, (Double)0.0);
        } else if (Node2 instanceof Control) {
            ((Control)Node2).setPrefSize(Width > 0.0 ? Width : -1.0, Height > 0.0 ? Height : -1.0);
        } else if (Node2 instanceof Region) {
            ((Region)Node2).setPrefSize(Width > 0.0 ? Width : -1.0, Height > 0.0 ? Height : -1.0);
        } else if (Node2 instanceof ImageView) {
            ((ImageView)Node2).setFitWidth(Width);
            ((ImageView)Node2).setFitHeight(Height);
        } else if (Node2 instanceof Canvas) {
            ((Canvas)Node2).setWidth(Width);
            ((Canvas)Node2).setHeight(Height);
        }
    }

    public Object getOrientation() {
        return ((Pane)this.getObject()).getNodeOrientation();
    }

    public void setOrientation(Object o) {
        ((Pane)this.getObject()).setNodeOrientation((NodeOrientation)o);
    }

    public int getNumberOfNodes() {
        return ((Pane)this.getObject()).getChildren().size();
    }

    public NodeWrapper.ConcreteNodeWrapper GetNode(int Index) {
        return (NodeWrapper.ConcreteNodeWrapper)AbsObjectWrapper.ConvertToWrapper(new NodeWrapper.ConcreteNodeWrapper(), ((Pane)this.getObject()).getChildren().get(Index));
    }

    @Override
    @BA.Hide
    public int getSize() {
        return this.getNumberOfNodes();
    }

    @Override
    @BA.Hide
    public Object Get(int index) {
        return ((Pane)this.getObject()).getChildren().get(index);
    }

    @BA.Hide
    public static int[] getDesignerWidthAndHeight(Pane pane) {
        int w = (int)pane.getPrefWidth();
        int h = (int)pane.getPrefHeight();
        if (w < 0 || h < 0) {
            w = (int)pane.getWidth();
            h = (int)pane.getHeight();
        }
        return new int[]{w, h};
    }

    @BA.Hide
    public static class AllViewsIterator
    implements BA.IterableList {
        private ArrayList<Node> views = new ArrayList();

        public AllViewsIterator(Parent parent) {
            this.addViews(parent);
        }

        private void addViews(Parent parent) {
            for (Node n : parent.getChildrenUnmodifiable()) {
                this.views.add(n);
                if (!(n instanceof Parent)) continue;
                this.addViews((Parent)n);
            }
        }

        @Override
        public Object Get(int index) {
            return this.views.get(index);
        }

        @Override
        public int getSize() {
            return this.views.size();
        }
    }

    @BA.ShortName(value="AnchorPane")
    public static class AnchorPaneWrapper
    extends PaneWrapper<AnchorPane> {
        @Override
        @BA.Hide
        public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new AnchorPane());
            }
            super.innerInitialize(ba, eventName, true);
        }

        public void SetAnchors(Node Child, double Left, double Top, double Right, double Bottom) {
            this.checkResize(Child);
            this.SetLeftAnchor(Child, Left);
            this.SetTopAnchor(Child, Top);
            this.SetRightAnchor(Child, Right);
            this.SetBottomAnchor(Child, Bottom);
        }

        public void FillHorizontally(Node Child, double DistanceFromLeft, double DistanceFromRight) {
            this.checkResize(Child);
            this.SetLeftAnchor(Child, DistanceFromLeft);
            this.SetRightAnchor(Child, DistanceFromRight);
        }

        public void FillVertically(Node Child, double DistanceFromTop, double DistanceFromBottom) {
            this.checkResize(Child);
            this.SetTopAnchor(Child, DistanceFromTop);
            this.SetBottomAnchor(Child, DistanceFromBottom);
        }

        public double GetLeftAnchor(Node Child) {
            Double d = AnchorPane.getLeftAnchor((Node)Child);
            return d == null ? -1.0 : d;
        }

        public double GetTopAnchor(Node Child) {
            Double d = AnchorPane.getTopAnchor((Node)Child);
            return d == null ? -1.0 : d;
        }

        public double GetBottomAnchor(Node Child) {
            Double d = AnchorPane.getBottomAnchor((Node)Child);
            return d == null ? -1.0 : d;
        }

        public double GetRightAnchor(Node Child) {
            Double d = AnchorPane.getRightAnchor((Node)Child);
            return d == null ? -1.0 : d;
        }

        private void checkResize(Node Child) {
            if (!Child.isResizable()) {
                BA.Log("Child is not resizable: " + Child);
            }
        }

        public void SetLeftAnchor(Node Child, double Offset) {
            this.checkResize(Child);
            AnchorPane.setLeftAnchor((Node)Child, (Double)(Offset == -1.0 ? null : Double.valueOf(Offset)));
        }

        public void SetTopAnchor(Node Child, double Offset) {
            this.checkResize(Child);
            AnchorPane.setTopAnchor((Node)Child, (Double)(Offset == -1.0 ? null : Double.valueOf(Offset)));
        }

        public void SetBottomAnchor(Node Child, double Offset) {
            this.checkResize(Child);
            AnchorPane.setBottomAnchor((Node)Child, (Double)(Offset == -1.0 ? null : Double.valueOf(Offset)));
        }

        public void SetRightAnchor(Node Child, double Offset) {
            this.checkResize(Child);
            AnchorPane.setRightAnchor((Node)Child, (Double)(Offset == -1.0 ? null : Double.valueOf(Offset)));
        }
    }

    @BA.ShortName(value="Pane")
    public static class ConcretePaneWrapper
    extends PaneWrapper<Pane> {
        @Override
        @BA.Hide
        public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new NonResizePane());
            }
            super.innerInitialize(ba, eventName, true);
        }

        @BA.Hide
        public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
            Pane vg = (Pane)prev;
            if (vg == null) {
                vg = NodeWrapper.buildNativeView(NonResizePane.class, props, designer);
                final Rectangle clipRectangle = new Rectangle();
                vg.setClip((Node)clipRectangle);
                vg.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

                    public void changed(ObservableValue<? extends Bounds> arg0, Bounds arg1, Bounds arg2) {
                        clipRectangle.setWidth(arg2.getWidth());
                        clipRectangle.setHeight(arg2.getHeight());
                    }
                });
            }
            vg = (Pane)NodeWrapper.build(vg, props, designer);
            vg.prefWidth((double)((Integer)props.get("width")).intValue());
            vg.prefHeight((double)((Integer)props.get("height")).intValue());
            ConcretePaneWrapper.setRTLOrientation((Node)vg, props);
            return vg;
        }

        @BA.Hide
        public static void setRTLOrientation(Node pane, Map<String, Object> props) {
            String orientation = BA.gm(props, "orientation", "INHERIT");
            pane.setNodeOrientation(BA.getEnumFromString(NodeOrientation.class, orientation));
        }

        @BA.Hide
        public static class NonResizePane
        extends Pane {
            protected double computePrefHeight(double width) {
                return this.getPrefWidth();
            }

            protected double computePrefWidth(double width) {
                return this.getPrefWidth();
            }
        }
    }

    @BA.Hide
    public static class NativeAndWrapper {
        public final Class<?> nativeClass;
        public final Class<?> wrapperClass;

        public NativeAndWrapper(Class<?> nativeClass, Class<?> wrapperClass) {
            this.nativeClass = nativeClass;
            this.wrapperClass = wrapperClass;
        }
    }

    @BA.Hide
    public static class ResizeEventManager {
        private double lastWidth;
        private double lastHeight;

        public ResizeEventManager(final Pane pane, final Control control, final Runnable eventHandler) {
            final Runnable r = new Runnable(){

                @Override
                public void run() {
                    double h;
                    double w = pane != null ? pane.getWidth() : control.getWidth();
                    double d = h = pane != null ? pane.getHeight() : control.getHeight();
                    if (w != ResizeEventManager.this.lastWidth || h != ResizeEventManager.this.lastHeight) {
                        ResizeEventManager.this.lastWidth = w;
                        ResizeEventManager.this.lastHeight = h;
                        if (w != 0.0 && h != 0.0) {
                            eventHandler.run();
                        }
                    }
                }
            };
            ReadOnlyDoubleProperty widthProp = pane != null ? pane.widthProperty() : control.widthProperty();
            widthProp.addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                    if (pane != null && pane.getScene() != null && pane.getScene().getRoot() != pane) {
                        r.run();
                    } else {
                        Platform.runLater((Runnable)r);
                    }
                }
            });
            ReadOnlyDoubleProperty heightProp = pane != null ? pane.heightProperty() : control.heightProperty();
            heightProp.addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                    if (pane != null && pane.getScene() != null && pane.getScene().getRoot() != pane) {
                        r.run();
                    } else {
                        Platform.runLater((Runnable)r);
                    }
                }
            });
        }
    }
}

