/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects.collections;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.objects.collections.Map;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@BA.Version(value=1.21f)
@BA.ShortName(value="JSONParser")
public class JSONParser
extends AbsObjectWrapper<JSONTokener> {
    public void Initialize(String Text2) {
        JSONTokener j = new JSONTokener(Text2);
        this.setObject(j);
    }

    public Map NextObject() throws JSONException {
        Object o = ((JSONTokener)this.getObject()).nextValue();
        if (!(o instanceof JSONObject)) {
            throw new RuntimeException("JSON Object expected.");
        }
        Map m = new Map();
        m.setObject(this.convertObjToMap((JSONObject)o));
        return m;
    }

    public anywheresoftware.b4a.objects.collections.List NextArray() throws JSONException {
        Object o = ((JSONTokener)this.getObject()).nextValue();
        if (!(o instanceof JSONArray)) {
            throw new RuntimeException("JSON Array expected.");
        }
        anywheresoftware.b4a.objects.collections.List l = new anywheresoftware.b4a.objects.collections.List();
        l.setObject(this.convertObjToList((JSONArray)o));
        return l;
    }

    public Object NextValue() throws JSONException {
        Object o = ((JSONTokener)this.getObject()).nextValue();
        if (o instanceof JSONObject || o instanceof JSONArray) {
            throw new RuntimeException("Simple value expected.");
        }
        return o;
    }

    private Map.MyMap convertObjToMap(JSONObject j) throws JSONException {
        Map.MyMap m = new Map.MyMap();
        Iterator it = j.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = j.get(key);
            if (JSONObject.NULL.equals(value)) {
                m.put(key, (Object)null);
                continue;
            }
            if (value instanceof JSONObject) {
                m.put(key, this.convertObjToMap((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                m.put(key, this.convertObjToList((JSONArray)value));
                continue;
            }
            m.put(key, value);
        }
        return m;
    }

    private ArrayList<Object> convertObjToList(JSONArray ja) throws JSONException {
        ArrayList<Object> a = new ArrayList<Object>(ja.length());
        int i = 0;
        while (i < ja.length()) {
            Object value = ja.get(i);
            if (JSONObject.NULL.equals(value)) {
                a.add(null);
            } else if (value instanceof JSONObject) {
                a.add(this.convertObjToMap((JSONObject)value));
            } else if (value instanceof JSONArray) {
                a.add(this.convertObjToList((JSONArray)value));
            } else {
                a.add(value);
            }
            ++i;
        }
        return a;
    }

    @BA.ShortName(value="JSON")
    public static class JSONConverter
    extends AbsObjectWrapper<Object> {
        public String ToString() throws Exception {
            return this.ToStringImpl(true);
        }

        public String ToCompactString() throws Exception {
            return this.ToStringImpl(false);
        }

        private String ToStringImpl(boolean pretty) throws Exception {
            JSONGenerator g = new JSONGenerator();
            Object o = this.getObject();
            if (o instanceof Map.MyMap) {
                g.Initialize((Map)AbsObjectWrapper.ConvertToWrapper(new Map(), (Map.MyMap)o));
            } else if (o instanceof List) {
                g.Initialize2((anywheresoftware.b4a.objects.collections.List)AbsObjectWrapper.ConvertToWrapper(new anywheresoftware.b4a.objects.collections.List(), o));
            } else {
                throw new RuntimeException("Only Maps and Lists are supported");
            }
            return pretty ? g.ToPrettyString(4) : g.ToString();
        }

        public Map ToMap() throws JSONException {
            return this.stringToObject().NextObject();
        }

        public anywheresoftware.b4a.objects.collections.List ToList() throws JSONException {
            return this.stringToObject().NextArray();
        }

        private JSONParser stringToObject() {
            Object o = this.getObject();
            if (!(o instanceof String)) {
                throw new RuntimeException("String expected");
            }
            JSONParser p = new JSONParser();
            p.Initialize((String)o);
            return p;
        }
    }

    @BA.ShortName(value="JSONGenerator")
    public static class JSONGenerator {
        Object json;

        public void Initialize(Map Map2) throws Exception {
            this.json = this.convertMapToJO((Map.MyMap)Map2.getObject());
        }

        public void Initialize2(anywheresoftware.b4a.objects.collections.List List2) throws Exception {
            this.json = this.convertListToJA((List)List2.getObject());
        }

        public String ToString() {
            if (this.json == null) {
                throw new RuntimeException("JSON was not initialized.");
            }
            if (this.json instanceof JSONObject) {
                return ((JSONObject)this.json).toString();
            }
            return ((JSONArray)this.json).toString();
        }

        public String ToPrettyString(int Indent) throws JSONException {
            if (this.json == null) {
                throw new RuntimeException("JSON was not initialized.");
            }
            if (this.json instanceof JSONObject) {
                return ((JSONObject)this.json).toString(Indent);
            }
            return ((JSONArray)this.json).toString(Indent);
        }

        private JSONObject convertMapToJO(Map.MyMap map) throws JSONException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
            JSONObject j = new JSONObject();
            for (Map.Entry<Object, Object> e : map.entrySet()) {
                String key = String.valueOf(e.getKey());
                Object o = e.getValue();
                if (o instanceof Map.MyMap) {
                    j.put(key, this.convertMapToJO((Map.MyMap)o));
                    continue;
                }
                if (o instanceof Map) {
                    j.put(key, this.convertMapToJO((Map.MyMap)((Map)o).getObject()));
                    continue;
                }
                if (o instanceof List) {
                    j.put(key, this.convertListToJA((List)o));
                    continue;
                }
                if (o instanceof anywheresoftware.b4a.objects.collections.List) {
                    j.put(key, this.convertListToJA((List)((anywheresoftware.b4a.objects.collections.List)o).getObject()));
                    continue;
                }
                if (o == null) {
                    j.put(key, JSONObject.NULL);
                    continue;
                }
                if (o.getClass().isArray()) {
                    j.put(key, this.convertListToJA((List)this.arrayToList(o).getObject()));
                    continue;
                }
                j.put(key, o);
            }
            return j;
        }

        private JSONArray convertListToJA(List<Object> list) throws JSONException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
            JSONArray ja = new JSONArray();
            for (Object o : list) {
                if (o instanceof Map.MyMap) {
                    ja.put(this.convertMapToJO((Map.MyMap)o));
                    continue;
                }
                if (o instanceof Map) {
                    ja.put(this.convertMapToJO((Map.MyMap)((Map)o).getObject()));
                    continue;
                }
                if (o instanceof List) {
                    ja.put(this.convertListToJA((List)o));
                    continue;
                }
                if (o instanceof anywheresoftware.b4a.objects.collections.List) {
                    ja.put(this.convertListToJA((List)((anywheresoftware.b4a.objects.collections.List)o).getObject()));
                    continue;
                }
                if (o == null) {
                    ja.put(JSONObject.NULL);
                    continue;
                }
                if (o.getClass().isArray()) {
                    ja.put(this.convertListToJA((List)this.arrayToList(o).getObject()));
                    continue;
                }
                ja.put(o);
            }
            return ja;
        }

        private anywheresoftware.b4a.objects.collections.List arrayToList(Object o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
            anywheresoftware.b4a.objects.collections.List l = o.getClass().getComponentType().isPrimitive() ? (anywheresoftware.b4a.objects.collections.List)Common.class.getMethod("ArrayToList", o.getClass()).invoke(null, o) : Common.ArrayToList((Object[])o);
            return l;
        }
    }
}

